/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendarySchemeMaker;

import LegendaryCardMaker.CardMakerToolbar;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendarySchemeMaker.Scheme;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCard;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCardType;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeMaker;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeMakerFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Random;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SchemeSelectorMenu
extends JMenu
implements ActionListener {
    JMenuItem newHero = new JMenuItem("New Scheme...");
    JMenuItem edit = new JMenuItem("Edit Scheme...");
    JMenuItem rename = new JMenuItem("Rename Scheme...");
    JMenuItem delete = new JMenuItem("Delete Scheme...");
    JMenuItem copy = new JMenuItem("Copy Scheme...");
    JMenuItem random = new JMenuItem("Random Scheme...");
    public LegendaryCardMakerFrame lcmf;
    static CardMakerToolbar tb = null;

    public SchemeSelectorMenu(LegendaryCardMakerFrame lcmf, CardMakerToolbar tb) {
        SchemeSelectorMenu.tb = tb;
        this.lcmf = lcmf;
        this.setText("Edit");
        this.newHero.addActionListener(this);
        this.add(this.newHero);
        this.addSeparator();
        this.edit.addActionListener(this);
        this.add(this.edit);
        this.delete.addActionListener(this);
        this.add(this.delete);
        this.addSeparator();
        this.copy.addActionListener(this);
        this.add(this.copy);
        this.addSeparator();
        this.random.addActionListener(this);
        this.add(this.random);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.newHero)) {
            String s = JOptionPane.showInputDialog(this.lcmf, "Enter the Scheme Name", "");
            if (s == null) {
                return;
            }
            if (s != null && s.isEmpty()) {
                return;
            }
            Scheme h = new Scheme();
            h.name = s;
            h.changed = true;
            SchemeCard hc = SchemeMaker.getBlankSchemeCard();
            hc.name = h.name;
            hc.cardType = SchemeCardType.valueOf("SCHEME");
            hc.changed = true;
            h.cards.add(hc);
            this.lcmf.schemeListModel.addElement(hc);
            this.lcmf.lcm.schemes.add(hc);
        }
        if (e.getSource().equals(this.delete)) {
            if (this.getCurrentScheme() == null) {
                return;
            }
            int outcome = JOptionPane.showOptionDialog(this.lcmf, "Delete Scheme?", "Delete Scheme?", 0, 3, null, null, null);
            if (outcome == 0) {
                this.lcmf.lcm.schemes.remove(this.getCurrentScheme());
                this.getSchemeListModel().removeElement(this.getCurrentScheme());
            }
        }
        if (e.getSource().equals(this.edit)) {
            if (this.getCurrentScheme() == null) {
                return;
            }
            new SchemeMakerFrame(this.getCurrentScheme());
        }
        if (e.getSource().equals(this.copy)) {
            if (this.getCurrentScheme() == null) {
                return;
            }
            SchemeCard c = this.getCurrentScheme().getCopy();
            this.lcmf.schemeListModel.addElement(c);
            this.lcmf.lcm.schemes.add(c);
        }
        if (e.getSource().equals(this.random) && this.lcmf.schemeListModel.size() > 0) {
            Random rand = new Random(new Date().getTime());
            new SchemeMakerFrame((SchemeCard)this.lcmf.schemeListModel.get(rand.nextInt(this.lcmf.schemeListModel.size())));
        }
    }

    public JList getSchemeList() {
        return this.lcmf.schemeList;
    }

    public DefaultListModel getSchemeListModel() {
        return this.lcmf.schemeListModel;
    }

    public SchemeCard getCurrentScheme() {
        SchemeCard h = null;
        if (this.lcmf.schemeListModel.size() > 0 && this.lcmf.schemeList.getSelectedIndex() >= 0) {
            h = (SchemeCard)this.lcmf.schemeListModel.get(this.lcmf.schemeList.getSelectedIndex());
        }
        return h;
    }
}

